


// MARK: - painter funcs

function fillPainter(color)
{
    return {
        nsClass: "GXPainter",
        gxFillColor: color,
    };
}

function fillPainterWithSize(color, size)	// size expected as string, eg. "10, 20"
{
    return {
        nsClass: "GXPainter",
        gxFillColor: color,
		gxDefaultSize: size,
    };
}

function roundRectPainter(color, radius)
{
    return {
        nsClass: "GXPainter",
        gxFillColor: color,
        gxCornerRadius: radius,
    };
}


// MARK: - view funcs

function labelView(text, styles, valueKey)
{
	if (valueKey == null)
		valueKey = "";
	
    return {
        "+": "LabelView.right.size13." + styles,
        gxDefaultValue: text,
		gxValueKey: valueKey,
    };
}

function spacerView()
{
    return {
        nsClass: "GXDrawView",
        gxHidden: true,
    };
}

function filledView(color)
{
    return {
        nsClass: "GXDrawView",
        gxBackPainter: fillPainter(color),
    };
}

function dividerView(color)
{
	color = color || "BackColor3";
	return {
		nsClass: "GXDrawView",
		gxLayout:
		[
			"V:[self(1)]",
			"H:|-0-[self]-0-|",
		],
		gxBackPainter: fillPainter(color),
	};
}

function groupTitleView(title, styles)
{
	var template = "GroupTitleView";
	if (styles != null)
		template = "GroupTitleView." + styles;
	
	return {
		"+": template,
		gxDefaultValue: title,
	};
}


// MARK: - formatter funcs

function disclosureAxFormatter(title)
{
	return {
		nsClass: "GXDictionaryFormatter",
		gxDictionary: {
			0: title + ", collapsed",
			1: title + ", expanded",
		}
	};
}


// MARK: - enclosure view

function enclosureView(viewName, subViewMarkup)
{
	return {
		nsClass: "GXDrawView",
		gxHideOnNilValue: true,
		gxLayout: [
			"H:|-0-[self]-0-|",
			"V:|-(-999)-[self(34)]"	// vertical position set by parent
		],
		gxViewName: viewName,	// viewName is shared with enclosure, so it hides when value is nil (auto value lookup)
		gxChildViews:
		{
			[viewName]: subViewMarkup,
		},
	};
}


// MARK: - menu funcs

function menuItem(title, repValue, styles, displayValue)
{
	return {
		"+": "MenuItem." + styles,
		gxTitle: title,
		gxDisplayValue: displayValue ? displayValue : title,	// displayed by popupmenu when selected
		gxValue: repValue,
	};
}

function menuDivider()
{
	return {
		"+": "MenuItem",
		gxIsSeparator: true,
	};
}


// MARK: - experiments (mostly unused)

Object.defineProperty( Object.prototype, "insets",
{ enumerable: false,
  value: function(insets)
		  {
			  var result = Object.create(this);
			  result.gxEdgeInsets = insets;
			  return result;
		  }
});
